﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO;
using System.Windows.Forms;


namespace FajlBeolvasas
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {

        private delegate void dUpdateAdat(AdatInfo pValue);

        public class MyAsyncInfo
        {
            public Byte[] ByteArray { get; set; }
            public Stream MyStream { get; set; }

            public MyAsyncInfo(Byte[] array, Stream stream)
            {
                ByteArray = array;
                MyStream = stream;
            }
        }

        public class AdatInfo
        {
            public int meret { get; set; }
            public string szoveg { get; set; }

            public AdatInfo(int m, string s)
            {
                meret = m;
                szoveg = s;
            }
        }

        int prValue;
        
        public MainWindow()
        {
            InitializeComponent();
        }


        private void UpdateAdat(AdatInfo pValue)
        {
            this.T_ADAT.Text = this.T_ADAT.Text + pValue.szoveg;
            this.T_MERET.Text = (string)pValue.meret.ToString();
        }


        private void beolvas()
        {

            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Multiselect = false;
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.Cancel)
            { return; }


            FileStream stream = null;
            try
            {
                stream = File.OpenRead(ofd.FileName);

            }
            catch (Exception)
            {
                System.Windows.MessageBox.Show("A fájlt nem lehet megnyitni.");
                return;
            }

            Byte[] myByteArray = new Byte[1000];

            MyAsyncInfo info;
            info = new MyAsyncInfo(myByteArray, stream);

            try
            {
                stream.BeginRead(myByteArray, 0, 1000,
                  new AsyncCallback(OnRead), info);

            }
            catch (Exception)
            {
                System.Windows.MessageBox.Show("Nem sikerült az olvasás.");
                stream.Close();
            }
        }


        private void OnRead(IAsyncResult ar)
        {
            MyAsyncInfo info = (MyAsyncInfo)ar.AsyncState;

            int amountRead = 0;
            try
            {
                amountRead = info.MyStream.EndRead(ar);
                prValue += amountRead;

            }
            catch (Exception)
            {
                System.Windows.MessageBox.Show("Nem sikerült a fájl olvasása.");
                info.MyStream.Close();
                return;
            }
            string text = Encoding.UTF8.GetString(info.ByteArray, 0, amountRead);

            AdatInfo adat = new AdatInfo(prValue,text);

            dUpdateAdat mUpdateAdat = new dUpdateAdat(UpdateAdat);
            this.T_ADAT.Dispatcher.Invoke(System.Windows.Threading.DispatcherPriority.Background, mUpdateAdat, adat);
            //this.T_ADAT.Text = this.T_ADAT.Text + text;

            if (info.MyStream.Position < info.MyStream.Length)
            {
                try
                {

                    info.MyStream.BeginRead(info.ByteArray, 0,
                      1000, new AsyncCallback(OnRead), info);
                }
                catch (Exception)
                {
                    System.Windows.MessageBox.Show("Nem sikerült az olvasás folytatása.");
                    info.MyStream.Close();
                }
            }
            else
            {
                info.MyStream.Close();
                System.Windows.MessageBox.Show("Az olvasás befejeződött.");
            }
        }


        private void Button_Click(object sender, RoutedEventArgs e)
        {
            beolvas();
        }
    }
}
