﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO;
using System.Windows.Forms;


namespace WpfApplication44
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private delegate void dUpdateProgressBar(int pValue);

        private void UpdateProgressBar(int pValue)
        {
            this.progressBar1.Value = pValue;
        }

        public Stream celStream;
        public int prValue;

        public class MyAsyncInfo
        {
            public Byte[] ByteArray { get; set; }
            public Stream MyStream { get; set; }

            public MyAsyncInfo(Byte[] array, Stream stream)
            {
                ByteArray = array;
                MyStream = stream;
            }
        }
        

        private void masol()
        {
            string celnev;

            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Multiselect = false;
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.Cancel)
            { return; }
            

            FileStream stream = null;
            try
            {
                celnev = ofd.FileName + "_old";
                stream = File.OpenRead(ofd.FileName);
                celStream = File.Create(celnev);
                this.progressBar1.Maximum = (int)stream.Length;
                prValue = 0;
                this.progressBar1.Value = 0;
                
            }
            catch (Exception)
            {
                System.Windows.MessageBox.Show("A fájlt nem lehet megnyitni.");
                return;
            }

            Byte[] myByteArray = new Byte[1000];

            try
            {
                stream.BeginRead(myByteArray, 0, 1000,
                  new AsyncCallback(OnRead), new MyAsyncInfo(myByteArray, stream));
            }
            catch (Exception)
            {
                System.Windows.MessageBox.Show("Nem sikerült az olvasás.");
                stream.Close();
            }
        }
       
        private void OnRead(IAsyncResult ar)
        {
            MyAsyncInfo info = (MyAsyncInfo)ar.AsyncState;

            int amountRead = 0;
            try
            { 
                amountRead = info.MyStream.EndRead(ar);
                prValue += amountRead;

            }
            catch (Exception)
            {
                System.Windows.MessageBox.Show("Nem sikerült a fájl olvasása.");
                info.MyStream.Close();
                return;
            }

            string text = Encoding.UTF8.GetString(info.ByteArray, 0, amountRead);

            dUpdateProgressBar mUpdateProgressBar = new dUpdateProgressBar(UpdateProgressBar);
            this.Dispatcher.Invoke(System.Windows.Threading.DispatcherPriority.Send, mUpdateProgressBar, prValue);

            celStream.Write(info.ByteArray, 0, amountRead);
            if (info.MyStream.Position < info.MyStream.Length)
            {
                try
                {
                   
                    info.MyStream.BeginRead(info.ByteArray, 0,
                      1000, new AsyncCallback(OnRead), info);
                }
                catch (Exception)
                {
                    System.Windows.MessageBox.Show("Nem sikerült az olvasás folytatása.");
                    info.MyStream.Close();
                }
            }
            else
            {
                info.MyStream.Close();
                celStream.Close();
                System.Windows.MessageBox.Show("Az olvasás befejeződött.");
            }
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            masol();
        }
    }
}
