/*** Base-level program ***/

#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>

#define ERROR_PARAM  1
#define ERROR_FILE   2
#define ERROR_MALLOC 3

typedef struct Unit{
   int data;
   struct Unit *next;
   } Elem;
   
void push(Elem **f,int d){
   Elem *temp;
   temp = (Elem*)malloc(sizeof(Elem));
   if(temp==NULL){
      printf("Memory allocation error!\n");
      exit(ERROR_MALLOC);
      }   
   temp->data = d;
   temp->next = (*f);
   (*f)       = temp;
   }
   
int pop(Elem **f){
   int  d;
   Elem *temp;
   if((*f)==NULL) return -1;
   temp = (*f);
   d    = temp->data;
   (*f) = temp->next;
   free(temp);
   return d;
   }  
   
int main(int argc, char *argv[]){
   int  d;
   Elem *fej;
   FILE *infile;
   if(argc==1){
      printf("Too few parameters!\nGive a filename!\n");
      exit(ERROR_PARAM);
      }
   fej = NULL;
   infile=fopen(argv[1],"r");
   if(infile==NULL){
      printf("Problem with \"%s\" file!\n",argv[1]);
      exit(ERROR_FILE);
      }
   while(!feof(infile)){
      fscanf(infile,"%d", &d);
      push(&fej,d);  
      }
   fclose(infile);
   
   while(fej!=NULL){
      d=pop(&fej);
      printf("%d ",d);
      }
   printf("\n");
   
   return 0;
}
